/****** Object:  StoredProcedure [dbo].[P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL]    Script Date: 14/04/2014 17:43:08 ******/
 
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL]
GO
--EXEC P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL '2013-07-01','2013-07-31',1
CREATE PROCEDURE [dbo].[P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL] @DT_INI DATETIME = NULL, @DT_FIM DATETIME = NULL, @FLAG_REPROCESSAR INT=0  AS  
 
/*
=======================================================================================
'Job.................: Itec - Geração PIS e Cofin
'Função..............: 
'Objetivo............: Gera pis cofins dos itens 
'Tabelas.............: EST_NF_ENT_IT | EST_NF_SAI_IT
'Dt Modificação......: 18/11/2020
'Modificação.........: Tag #A001 - Tratamento de exceção  
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/
Set nocount on;
Declare @SqlTexto varchar(500);
Set deadlock_priority high;
Set transaction isolation level read uncommitted;

BEGIN TRY

DECLARE @CD_FILIAL INT
 
IF @DT_INI IS NULL
begin
	SELECT @DT_INI=dbo.F_ONTEM()
	SET @DT_FIM = @DT_INI
	SET @DT_INI= @DT_INI -2
end

print 'P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL - SELECT 1 ' + CONVERT(VARCHAR, GETDATE(), 108);

DECLARE filiais CURSOR FAST_FORWARD FOR 
	SELECT CD_FILIAL FROM PRC_FILIAL 
		ORDER BY CD_FILIAL


OPEN filiais
FETCH NEXT FROM filiais INTO @CD_FILIAL
	WHILE @@FETCH_STATUS=0
	  begin
		
		IF not EXISTS(SELECT TOP 1 CD_EMP
						FROM CTB_CONTROLE_EXPORTACAO
						WHERE LIBERADO = 'N'
								AND DT_EXPORT >= @DT_INI
								AND CD_EMP = 1
								AND CD_FILIAL = @CD_FILIAL
						UNION
						SELECT TOP 1 CD_EMP
						FROM CTB_EXP_CTR
						WHERE LIBERADO = 'N'
								AND CD_EMP = 1
								AND DT_EXP >= @DT_INI
								AND CD_FILIAL = @CD_FILIAL
								AND TP_EXP = 0)
		begin
		
			print 'EXEC 2 ' + CONVERT(VARCHAR, GETDATE(), 108) + ' Filial: ' + CONVERT(VARCHAR, @CD_FILIAL);
			set @SqlTexto = 'P_GERA_PIS_COFINS_PDV_VD 1, ' + Convert(varchar, @CD_FILIAL) + ' ,''' 
													+ Convert(varchar, @DT_INI, 112) + ''' ,''' + Convert(varchar, @DT_FIM,112) + ''',0,' + Convert(varchar,@FLAG_REPROCESSAR)
			EXEC (@SqlTexto);
			print @SqlTexto
			print 'EXEC 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
			EXEC P_GERA_PIS_COFINS_PDV_VD_DEV_EST_PROD_IMP 1,@CD_FILIAL,@DT_INI,@DT_FIM,0,@FLAG_REPROCESSAR;
		
			print 'EXEC 4 ' + CONVERT(VARCHAR, GETDATE(), 108);
			EXEC P_GERA_PIS_COFINS_EST_NF_SAI 1,@CD_FILIAL,@DT_INI,@DT_FIM,0,@FLAG_REPROCESSAR;
		
			print 'EXEC 5 ' + CONVERT(VARCHAR, GETDATE(), 108);
			EXEC P_GERA_PIS_COFINS_EST_NF_ENT 1,@CD_FILIAL,@DT_INI,@DT_FIM,0,@FLAG_REPROCESSAR;
		
		END 

		FETCH NEXT FROM filiais INTO @CD_FILIAL
	  end
CLOSE filiais;
DEALLOCATE filiais;

END TRY

-- Tag #A001
BEGIN CATCH

   DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
   DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
   DECLARE @ErrorState INT = ERROR_STATE();

   INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
	  SELECT
		 ERROR_NUMBER()			AS numero
		 ,@ErrorSeverity		AS severidade
		 ,@ErrorState			AS estado
		 ,ERROR_PROCEDURE()		AS rotina
		 ,ERROR_LINE()			AS linha
		 ,@ErrorMessage			AS mensagem
		 ,GETDATE()				AS dtErro ;

   RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
END CATCH;

go
sp_recompile 'P_GERA_PIS_COFINS_PDV_VD';
go
sp_recompile 'P_GERA_PIS_COFINS_PDV_VD_DEV_EST_PROD_IMP';
go
sp_recompile 'P_GERA_PIS_COFINS_EST_NF_SAI';
go
sp_recompile 'P_GERA_PIS_COFINS_EST_NF_ENT';
PRINT 'P_EST_NF_PDV_GERACAO_PIS_COFINS_EXECUTE_ALL FINALIZADA!'



